<?php namespace App\Controllers\Api\Customer\Profile\SubscribeExtra;

use App\Controllers\PrivateController;
use App\Libraries\Common;
use App\Models\AppsModel;
use App\Models\SubscribesExtraModel;
use App\Models\PlansExtraModel; // Thêm model PlansExtraModel
use CodeIgniter\HTTP\ResponseInterface;

define("LIMIT", 20);

class SubscribesExtra extends PrivateController
{
    /**************************************************************************************
     * PUBLIC FUNCTIONS
     **************************************************************************************/

    /**
     * Get user subscribes
     * @return ResponseInterface
     */
    public function index(): ResponseInterface
    {
        $offset = (int) $this->request->getGet("offset");

        $subscribes_extra = new SubscribesExtraModel();
      
      	$plansExtra = new PlansExtraModel(); // Khởi tạo PlansModel

        $list = $subscribes_extra
            ->where("user_id", $this->userId)
            ->where("is_disable", 0) // Kiểm tra trạng thái còn hạn
            ->orderBy("id", "DESC")
            ->findAll(LIMIT, $offset);

        $items = []; // Mảng để lưu thông tin đăng ký

        $common = new Common();

        if ($list) {
            $app_ids = [];
          	$plan_extra_ids = []; // Tạo mảng để lưu plan_extra_id
            foreach ($list as $item) {
                $app_ids[] = $item["app_id"];
              	$plan_extra_ids[] = $item["plan_extra_id"]; // Thêm plan_extra_id vào mảng
            }

            $projects = new AppsModel();

            $apps = $projects
                ->whereIn("id", $app_ids)
                ->select("uid,name,id")
                ->findAll();
          
          	// Lấy thông tin của các plan
            $plansExtraData = $plansExtra
                ->whereIn("id", $plan_extra_ids)
                ->findAll();

            foreach ($list as $item) {
                $app = null;
                foreach ($apps as $app_item) {
                    if ($app_item["id"] == $item["app_id"]) {
                        $app = $app_item;
                        break;
                    }
                }
              	
              	// Tìm plan tương ứng
                $plan_extra = null;
                foreach ($plansExtraData as $plan_extra_item) { // Sử dụng $plansExtraData thay vì $plans
                    if ($plan_extra_item["id"] == $item["plan_extra_id"]) {
                        $plan_extra = $plan_extra_item;
                        break;
                    }
                }
              	
                if ($app && $plan_extra) {
                    $items[] = [
                        "uid"        => $item["uid"],
                        "created_at" => date('d-m-Y H:i', $item['created_at']),
                        "price"      => $item["price"],
                        "app"        => [
                            "name" => $app["name"],
                            "uid"  => $app["uid"],
                            "icon" => $common->get_icon($app["uid"])
                        ],
                        "is_active"  => (bool) $item["is_active"],
                        "build_count_extra" => $plan_extra["build_count_extra"] ?? 0 // Lấy build_count_extra từ plan_extra
                    ];
                }
            }
        }

        $total = $subscribes_extra
            ->where("user_id", $this->userId)
            ->countAllResults();

        return $this->respond(["list" => $items, "total" => $total], 200);
    }
  	

    /**************************************************************************************
     * PRIVATE FUNCTIONS
     **************************************************************************************/


}