<?php namespace App\Controllers\Api\Ipn;

use App\Controllers\BaseController;
use App\Libraries\PaypalClient;
use App\Libraries\Payment;
use App\Libraries\Settings;
use CodeIgniter\HTTP\ResponseInterface;

class PayPal extends BaseController
{
    private $paypal;

    public function __construct()
    {
        $this->paypal = new PaypalClient();
    }

    public function index(): ResponseInterface
    {
        try {
            $bodyRaw = file_get_contents('php://input');

            $result = $this->paypal->process_webhook($bodyRaw);

            if (!$result["event"]) {
                // Webhook not processed, skip
                return $this->respond(["status" => "ok"], 200);
            }

            $customValues = explode("_", $result["custom_id"]);

            $app_id = $customValues[0];
            $user_id = $customValues[1];
            $plan_id = $customValues[2];

            $payment = new Payment([
                "user_id" => $user_id,
                "app_id" => $app_id,
                "plan_id" => $plan_id,
            ]);

            switch ($result["event_type"]) {
                case "BILLING.SUBSCRIPTION.ACTIVATED":
                    $payment->create_subscription([
                        "subscribe_external_id" => $result["order_id"],
                        "customer_external_id" => $result["customer_id"],
                        "price" => (float)$result["amount"],
                        "method_route" => "paypal",
                    ]);
                    break;
                case "BILLING.SUBSCRIPTION.CANCELLED":
                    $payment->cancel_subscription([]);
                    break;
                case "PAYMENT.CAPTURE.COMPLETED":
                    $payment->create_subscription([
                        "subscribe_external_id" => $result["order_id"],
                        "customer_external_id" => $result["customer_id"],
                        "price" => (float)$result["amount"],
                        "method_route" => "paypal",
                    ]);
                    $payment->create_transaction([
                        "subscribe_external_id" => $result["order_id"],
                        "external_uid" => $result["resource_id"],
                        "price" => (float)$result["amount"],
                        "method_route" => "paypal",
                        "event_data" => $result,
                    ]);
                    break;
                case "PAYMENT.SALE.COMPLETED":
                    $payment->create_transaction([
                        "subscribe_external_id" => $result["order_id"],
                        "external_uid" => $result["resource_id"],
                        "price" => (float)$result["amount"],
                        "method_route" => "paypal",
                        "event_data" => $result,
                    ], true);
                    break;
                default:
                    break;
            }
            
            return $this->respond(["status" => "ok"], 200);
        } catch (\Exception $e) {
            log_message('error', $e);
            return $this->respond(["message" => $e->getMessage()], 400);
        }
    }

    public function capture(): ResponseInterface
    {
        $order_id = $this->request->getGet('token');
        $this->paypal->capture_order($order_id);

        $settings = new Settings();
        $frontUrl = $settings->get_config("site_url");
        return redirect()->to($frontUrl.'private/profile/subscribe');
    }
}
