<?php namespace App\Controllers\Api\Ipn;

use App\Controllers\BaseController;
use App\Libraries\Payment;
use App\Libraries\PaystackClient;
use CodeIgniter\HTTP\ResponseInterface;

class Paystack extends BaseController
{
    private $paystack;

    public function __construct()
    {
        $this->paystack = new PaystackClient();
    }

    public function index(): ResponseInterface
    {
        $bodyRaw = file_get_contents('php://input');
        $signature = $this->request->getHeaderLine("X-Paystack-Signature");

        $result = $this->paystack->process_webhook($bodyRaw, $signature);

        if (!$result["event"]) {
            // Webhook not processed, skip
            return $this->respond(["status" => "ok"], 200);
        }

        $customValues = explode("_", $result["custom_id"]);
        
        $app_id = $customValues[0];
        $user_id = $customValues[1];
        $plan_id = $customValues[2];
        
        $payment = new Payment([
            "user_id" => $user_id,
            "app_id" => $app_id,
            "plan_id" => $plan_id,
        ]);
        
        switch ($result["event_type"]) {
            case 'subscription.not_renew':
                $payment->cancel_subscription([]);
                break;

            case 'charge.success':
                $payment->create_subscription([
                    "subscribe_external_id" => $result["order_id"],
                    "customer_external_id" => $result["customer_id"],
                    "price" => (float)$result["amount"],
                    "method_route" => "paystack",
                ]);
                $payment->create_transaction([
                    "subscribe_external_id" => $result["order_id"],
                    "external_uid" => $result["resource_id"],
                    "price" => (float)$result["amount"],
                    "method_route" => "paystack",
                    "event_data" => $result["event_data"],
                ]);
                break;

            default:
                return $this->respond(["message" => "Unhandled event type"], 400);
        }

        return $this->respond(["status" => "ok"], 200);
    }
}
