<?php namespace App\Controllers\Api\Manager\PlansExtra;

use App\Controllers\PrivateController;
use App\Models\PlansExtraModel;
use CodeIgniter\HTTP\ResponseInterface;
use ReflectionException;

class CreatePlanExtra extends PrivateController
{
  	/**************************************************************************************
     * PUBLIC FUNCTIONS
     **************************************************************************************/

    /**
     * Create new plan extra
     * @return ResponseInterface
     * @throws ReflectionException
     */
    public function index(): ResponseInterface
    {
        if (!$this->validate($this->create_validation_type())) {
            return $this->respond(["message" => $this->validator->getErrors()], 400);
        }

        $plansExtra = new PlansExtraModel();

        $id = $plansExtra->insert([
            "build_count_extra" => (int) $this->request->getJsonVar("build_count_extra"),
            "price"             => esc($this->request->getJsonVar("price")),
            "save"              => esc($this->request->getJsonVar("save")),
            "api_id"            => esc($this->request->getJsonVar("api_id")),
            "status"            => 1
        ]);

        return $this->respond(["code" => 200, "id" => (int) $id], 200);
    }
  
  	/**************************************************************************************
     * PRIVATE FUNCTIONS
     **************************************************************************************/

    /**
     * Get validation rules for create plan extra
     * @return array
     */
    private function create_validation_type(): array
    {
        return [
            "build_count_extra" => [
                "label" => lang("Fields.field_159"),
                "rules" => "required|numeric|greater_than_equal_to[0]"
            ],
            "price" => [
                "label" => lang("Fields.field_105"),
                "rules" => "required|numeric"
            ],
            "save" => [
                "label" => lang("Fields.field_106"),
                "rules" => "required|numeric"
            ],
            "api_id" => [
                "label" => lang("Fields.field_151"),
                "rules" => "permit_empty|max_length[1000]"
            ]
        ];
    }
}