<?php namespace App\Controllers\Api;

use App\Controllers\BaseController;
use App\Libraries\UpdatesManager;
use CodeIgniter\HTTP\ResponseInterface;

class Updates extends BaseController
{
    private UpdatesManager $updatesManager;

    /**
     * Create models, config and library's
     */
    public function __construct()
    {
        $this->updatesManager = new UpdatesManager();
    }

    /**
     * Get installed version
     * @return ResponseInterface
     */
    public function get_installed_version(): ResponseInterface
    {
        $result = $this->updatesManager->get_installed_version();
        return $this->response->setJSON($result);
    }

    /**
     * Install repository updates
     * @return ResponseInterface
     */
    public function install_repository_updates(): ResponseInterface
    {
        $result = $this->updatesManager->install_repo_updates();
        return $this->response->setJSON($result);
    }

    /**
     * Get status of repository update process
     * @return ResponseInterface
     */
    public function get_repository_update_status(): ResponseInterface
    {
        $result = $this->updatesManager->get_repo_update_status();
        return $this->response->setJSON($result);
    }
}
