<?php
namespace App\Libraries;

use App\Models\DepositMethodsModel;

class DepositMethods
{
    private $depositMethods;

    function __construct()
    {
        $this->depositMethods = new DepositMethodsModel();
    }

    /**************************************************************************************
     * PUBLIC FUNCTIONS
     **************************************************************************************/

    /**
     * Get deposit method apikeys
     * @param string $route
     * @return array|null
     */
    public function get_deposit_method_apikeys(string $route): ?array
    {
        $method = $this->depositMethods
            ->where("route", esc($route))
            ->select("api_value_1, api_value_2, api_value_3")
            ->first();
        return !$method ? null : [
            "api_value_1" => $method["api_value_1"],
            "api_value_2" => $method["api_value_2"],
            "api_value_3" => $method["api_value_3"]
        ];
    }

    public function get_deposit_method_id(string $route): ?int
    {
        $method = $this->depositMethods
            ->where("route", esc($route))
            ->select("id")
            ->first();
        return !$method ? null : $method["id"];
    }
}
